/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.concurrent.Executor;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;

class NTFEventListener {
    private final AQNotificationListener aqlistener;
    private final DatabaseChangeListener dcnlistener;
    private final XSEventListener xslistener;
    private Executor executor = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    NTFEventListener(DatabaseChangeListener databaseChangeListener) throws SQLException {
        if (databaseChangeListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.dcnlistener = databaseChangeListener;
        this.aqlistener = null;
        this.xslistener = null;
    }

    NTFEventListener(AQNotificationListener aQNotificationListener) throws SQLException {
        if (aQNotificationListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.aqlistener = aQNotificationListener;
        this.dcnlistener = null;
        this.xslistener = null;
    }

    NTFEventListener(XSEventListener xSEventListener) throws SQLException {
        if (xSEventListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.aqlistener = null;
        this.dcnlistener = null;
        this.xslistener = xSEventListener;
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    Executor getExecutor() {
        return this.executor;
    }

    EventListener getListener() {
        EventListener eventListener = this.dcnlistener;
        if (eventListener == null) {
            eventListener = this.aqlistener;
        }
        return eventListener;
    }

    AQNotificationListener getAQListener() {
        return this.aqlistener;
    }

    DatabaseChangeListener getDCNListener() {
        return this.dcnlistener;
    }

    XSEventListener getXSEventListener() {
        return this.xslistener;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

