/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.streams.ColumnValue;
import oracle.streams.StreamsException;

public class DefaultColumnValue
implements ColumnValue {
    protected String columnName = null;
    protected Datum columnData = null;
    protected int columnDataType = 0;
    protected boolean tdeFlag = false;
    protected int charsetId = 0;

    public DefaultColumnValue(String string, Datum datum, int n) throws StreamsException {
        if (null == string) {
            throw new StreamsException("columnName can not be null");
        }
        this.setColumnName(string);
        if (null == datum) {
            if (0 == n) {
                throw new StreamsException("columnDataType must be specified if columnData is null");
            }
            if (this.isValidDataType(n)) {
                this.columnDataType = n;
            } else {
                throw new StreamsException("specified columnDataType is invalid");
            }
        }
        this.columnData = datum;
    }

    protected DefaultColumnValue() {
    }

    public DefaultColumnValue(String string, Datum datum) throws StreamsException {
        if (null == string) {
            throw new StreamsException("columnName can not be null");
        }
        this.columnName = string;
        if (null == datum) {
            throw new StreamsException("columnData can not be null");
        }
        this.columnData = datum;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public Datum getColumnData() {
        return this.columnData;
    }

    public void setColumnData(Datum datum, int n) throws StreamsException {
        if (null == datum && !this.isValidDataType(n)) {
            throw new StreamsException("when columnData is null, a valid column data type must be specified");
        }
        this.columnData = datum;
        this.columnDataType = n;
    }

    public int getColumnDataType() {
        if (0 == this.columnDataType) {
            if (null != this.columnData) {
                if (this.columnData instanceof CHAR) {
                    this.columnDataType = 1;
                } else if (this.columnData instanceof NUMBER) {
                    this.columnDataType = 2;
                } else if (this.columnData instanceof DATE) {
                    this.columnDataType = 12;
                } else if (this.columnData instanceof RAW) {
                    this.columnDataType = 23;
                } else if (this.columnData instanceof TIMESTAMP) {
                    this.columnDataType = 180;
                } else if (this.columnData instanceof TIMESTAMPTZ) {
                    this.columnDataType = 181;
                } else if (this.columnData instanceof TIMESTAMPLTZ) {
                    this.columnDataType = 231;
                } else if (this.columnData instanceof INTERVALYM) {
                    this.columnDataType = 182;
                } else if (this.columnData instanceof INTERVALDS) {
                    this.columnDataType = 183;
                } else if (this.columnData instanceof INTERVALYM) {
                    this.columnDataType = 182;
                } else if (this.columnData instanceof BINARY_FLOAT) {
                    this.columnDataType = 100;
                } else if (this.columnData instanceof BINARY_DOUBLE) {
                    this.columnDataType = 101;
                }
            }
            return this.columnDataType;
        }
        return this.columnDataType;
    }

    public boolean getTDEFlag() {
        return this.tdeFlag;
    }

    public void setTDEFlag(boolean bl) {
        this.tdeFlag = bl;
    }

    public void setCharsetId(int n) {
        this.charsetId = n;
    }

    public int getCharsetId() {
        return this.charsetId;
    }

    private boolean isValidDataType(int n) {
        return 1 == n || 2 == n || 12 == n || 23 == n || 180 == n || 181 == n || 231 == n || 100 == n || 101 == n || 182 == n || 183 == n;
    }
}

